/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.scm.component.wire;

import com.technicalitiesmc.lib.circuit.component.CircuitComponent;
import com.technicalitiesmc.lib.circuit.interfaces.wire.Wire;
import com.technicalitiesmc.lib.circuit.interfaces.wire.WireConnectionState;
import com.technicalitiesmc.lib.math.VecDirection;

public class WireUtils {
    public static WireConnectionState getNextState(VecDirection side, WireConnectionState state, CircuitComponent neighbor, Class<?> sourceClass, Class<?> sinkClass) {
        if (state.isDisconnected()) {
            if (neighbor.getInterface(side.getOpposite(), Wire.class) != null) {
                return WireConnectionState.WIRE;
            }
            if (neighbor.getInterface(side.getOpposite(), sinkClass) != null) {
                return WireConnectionState.OUTPUT;
            }
        }
        if (state != WireConnectionState.INPUT && (neighbor.getInterface(side.getOpposite(), Wire.class) != null || neighbor.getInterface(side.getOpposite(), sourceClass) != null)) {
            return WireConnectionState.INPUT;
        }
        return WireConnectionState.DISCONNECTED;
    }

    public static boolean isValidState(VecDirection side, WireConnectionState state, CircuitComponent neighbor, Class<?> sourceClass, Class<?> sinkClass) {
        if (state == WireConnectionState.DISCONNECTED || state == WireConnectionState.FORCE_DISCONNECTED) {
            return true;
        }
        if (neighbor == null) {
            return false;
        }
        if (neighbor.getInterface(side.getOpposite(), Wire.class) != null) {
            return true;
        }
        return switch (state) {
            case WireConnectionState.INPUT -> {
                if (neighbor.getInterface(side.getOpposite(), sourceClass) != null) {
                    yield true;
                }
                yield false;
            }
            case WireConnectionState.OUTPUT -> {
                if (neighbor.getInterface(side.getOpposite(), sinkClass) != null) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

